package models

import (
	"database/sql"
	"log"
	"net"
)

type ParseIp struct {
	Id       int `db:"id"`
	ClientId int `db:"client_id"`
}

func GetMaxIdParseIp() int {
	id := sql.NullInt64{}
	err := db.Get(&id, "SELECT MAX(client_id) FROM parse_ip")
	if err != nil {
		log.Fatalln(err)
	}

	return int(id.Int64)
}

func InsertParseIp(values ParseIp) int {
	var id int

	query, err := db.PrepareNamed("INSERT INTO parse_ip (client_id) VALUES (:client_id) RETURNING id")
	if err != nil {
		log.Fatalln(err)
	}

	err = query.QueryRow(values).Scan(&id)
	if err != nil {
		log.Fatalln(err)
	}

	return id
}

func ParseIpPrepareData(ip string) []string{
	//uri, err := url.Parse(strings.TrimSpace(data))
	//if err != nil{
	//	log.Fatalln(err)
	//}

	var result []string

	//host := strings.Replace(uri.Hostname(), "www.", "", 1)
	if net.ParseIP(ip) == nil {
		//ips, err := net.LookupIP(host)
		//if err != nil {
		//	log.Println(err)
		//} else {
			//result = ips
			//ParseIpSaveData(ips, hosts, tableType)
		//}
	} else {
		hosts, err := net.LookupAddr(ip)
		if err != nil{
			log.Println(err)
		} else {
			result = hosts
		}
	}

	return result
}

func ParseIpSaveData(hosts []string, tableId int) {
	hostIds := BatchParseIpHosts(hosts)

	for _, host := range hosts{
		if net.ParseIP(host) == nil {
			ips, err := net.LookupIP(host)
			if err != nil {
				log.Println(err)
			} else {
				parseIp := ParseIp{}
				parseIp.ClientId = tableId

				id := InsertParseIp(parseIp)
				ipIds := BatchParseIpIps(ips)

				if ipIds != nil {
					BatchParseIpHostsIps(id, ipIds, hostIds)
				}
			}
		}
	}
}